/***************************************/
/*  Use MADS http://mads.atari8.info/  */
/*  Mode: DLI (char mode)              */
/***************************************/

* 	icl "river8.h"

	org $00

fcnt	.ds 2
fadr	.ds 2
fhlp	.ds 2
cloc	.ds 1
regA	.ds 1
regX	.ds 1
regY	.ds 1

* ---	BASIC switch OFF
	org $5000\ mva #$ff portb\ rts\ ini $5000

* ---	MAIN PROGRAM
	org $4000


	.ALIGN $0400
fnt	ins "river8.fnt"

	ift USESPRITES
	.ALIGN $0800
	.ds $0300
pmg	SPRITES
	eif

ant	dta $44,a(scr)
	dta $04,$84,$04,$84,$04,$84,$84,$04,$84,$84,$04,$04,$84,$84,$84,$04
	dta $04,$84,$84,$84,$84,$04,$84,$84,$04,$04,$04,$04,$04
	dta $41,a(ant)
scr	ins "river8.scr"
main
* ---	init PMG

	ift USESPRITES
	mva >pmg pmbase		;missiles and players data address
	mva #$03 pmcntl		;enable players and missiles
	eif

	ift CHANGES		;if label CHANGES defined
	jsr save_color		;then save all colors and set value 0 for all colors
	eif

	lda:cmp:req $14		;wait 1 frame

	sei			;stop IRQ interrupts
	mva #$00 nmien		;stop NMI interrupts
	sta dmactl
	mva #$fe portb		;switch off ROM to get 16k more ram

	mwa #NMI $fffa		;new NMI handler

	mva #$c0 nmien		;switch on NMI+DLI again

	ift CHANGES		;if label CHANGES defined

	jsr fade_in		;fade in colors

_lp	lda TRIG0		;wait to press the trigger
	beq _fout
	lda CONSOL
	CMP #7
	beq _lp
_fout

	jsr fade_out		;fade out colors
	mva #$00 pmcntl		;PMG disabled
	tax
	sta:rne hposp0,x+

	mva #$ff portb		;ROM switch on
	mva #$40 nmien		;only NMI interrupts, DLI disabled
	cli			;IRQ enabled
	jmp $A000		;jump to main prg

	els

null	jmp dli1		;CPU is busy here, so no more routines allowed

	eif


* ---	DLI PROGRAM

	?old_dli = *

dli1
	lda vcount
	cmp #$02
	bne dli1
	:3 sta wsync
	DLINEW dli9


dli_start

dli9
	sta regA
	stx regX
	sty regY

	sta wsync		;line=24
	sta wsync		;line=25
	lda #$02
	sta wsync		;line=26
	sta gtictl
c9	lda #$78
	sta wsync		;line=27
	sta colpm1
c10	lda #$76
	sta wsync		;line=28
	sta colpm1
	sta wsync		;line=29
c11	lda #$78
	sta wsync		;line=30
	sta colpm1
c12	lda #$90
c13	ldx #$0E
c14	ldy #$96
	sta wsync		;line=31
	sta color0
	stx color1
	sty color2
c15	lda #$22
c16	ldx #$74
	sta wsync		;line=32
	sta color0
	stx colpm1
x8	lda #$B9
x9	ldx #$C1
	sta wsync		;line=33
	sta hposp1
	stx hposm1
	DLINEW dli10 1 1 1

dli10
	sta regA

	sta wsync		;line=40
	lda #$00
	sta wsync		;line=41
	sta gtictl
x10	lda #$B3
	sta wsync		;line=42
	sta hposm3
	DLINEW dli2 1 0 0

dli2
	sta regA
	lda >fnt+$400*$01
	sta wsync		;line=56
	sta chbase
	DLINEW dli11 1 0 0

dli11
	sta regA
	stx regX
	sty regY

c17	lda #$96
c18	ldx #$90
	sta wsync		;line=64
	sta color1
	stx color2
c19	lda #$00
	ldx #$02
x11	ldy #$A7
	sta wsync		;line=65
	sta color0
	stx gtictl
	sty hposp1
x12	lda #$AE
	sta hposm1
c20	lda #$F2
	sta colpm1
c21	lda #$C6
c22	ldx #$0E
c23	ldy #$96
	sta wsync		;line=66
	sta color0
	stx color1
	sty color2
c24	lda #$F2
	sta colpm0
c25	lda #$C2
c26	ldx #$06
c27	ldy #$0E
	sta wsync		;line=67
	sta color0
	stx color1
	sty color2
	sta wsync		;line=68
c28	lda #$0E
c29	ldx #$96
	sta wsync		;line=69
	sta color1
	stx color2
c30	lda #$06
c31	ldx #$0E
	sta wsync		;line=70
	sta color1
	stx color2
	sta wsync		;line=71
	sta wsync		;line=72
	lda #$01
s4	ldx #$00
x13	ldy #$AC
	sta wsync		;line=73
	sta gtictl
	stx sizep3
	sty hposp3
c32	lda #$00
	sta colpm3
s5	lda #$00
x14	ldx #$A0
c33	ldy #$f8
	sta wsync		;line=74
	sta sizep2
	stx hposp2
	sty colpm2
c34	lda #$0E
c35	ldx #$96
	sta wsync		;line=75
	sta color1
	stx color2
	DLINEW dli12 1 1 1

dli12
	sta regA
	stx regX

c36	lda #$00
	sta wsync		;line=80
	sta color0
	sta wsync		;line=81
	sta wsync		;line=82
	sta wsync		;line=83
c37	lda #$96
c38	ldx #$90
	sta wsync		;line=84
	sta color1
	stx color2
	DLINEW dli3 1 1 0

dli3
	sta regA
	lda >fnt+$400*$02
	sta wsync		;line=88
	sta chbase
	sta wsync		;line=89
	sta wsync		;line=90
	sta wsync		;line=91
	sta wsync		;line=92
	sta wsync		;line=93
	sta wsync		;line=94
	lda #$02
	sta wsync		;line=95
	sta gtictl
	sta wsync		;line=96
	lda #$04
	sta wsync		;line=97
	sta gtictl
	DLINEW dli13 1 0 0

dli13
	sta regA
	stx regX
	sty regY

	sta wsync		;line=112
	sta wsync		;line=113
	sta wsync		;line=114
s6	lda #$01
x15	ldx #$58
c39	ldy #$18
	sta wsync		;line=115
	sta sizep3
	stx hposp3
	sty colpm3
x16	lda #$5F
c40	ldx #$12
	sta wsync		;line=116
	sta hposp2
	stx colpm2
x17	lda #$5E
x18	ldx #$59
c41	ldy #$24
	sta wsync		;line=117
	sta hposp0
	stx hposp1
	sty colpm0
c42	lda #$2C
	sta colpm1
	DLINEW dli4 1 1 1

dli4
	sta regA
	lda >fnt+$400*$03
	sta wsync		;line=120
	sta chbase
	DLINEW dli14 1 0 0

dli14
	sta regA
	stx regX
	sty regY

	sta wsync		;line=128
	sta wsync		;line=129
	sta wsync		;line=130
	sta wsync		;line=131
	sta wsync		;line=132
x19	lda #$5C
	sta wsync		;line=133
	sta hposp2
x20	lda #$85
	sta wsync		;line=134
	sta hposm1
c43	lda #$2A
	sta wsync		;line=135
	sta colpm1
	sta wsync		;line=136
s7	lda #$30
x21	ldx #$81
x22	ldy #$91
	sta wsync		;line=137
	sta sizem
	stx hposp3
	sty hposm2
	sta wsync		;line=138
	sta wsync		;line=139
	sta wsync		;line=140
c44	lda #$18
	sta wsync		;line=141
	sta colpm1
	sta wsync		;line=142
x23	lda #$81
x24	ldx #$88
	sta wsync		;line=143
	sta hposp0
	stx hposp2
	lda >fnt+$400*$04
x25	ldx #$8E
	sta wsync		;line=144
	sta chbase
	stx hposm3
	sta wsync		;line=145
	lda #$02
x26	ldx #$7A
c45	ldy #$FC
	sta wsync		;line=146
	sta gtictl
	stx hposp1
	sty colpm1
	DLINEW dli15 1 1 1

dli15
	sta regA

	sta wsync		;line=152
x27	lda #$77
	sta wsync		;line=153
	sta hposp1
	sta wsync		;line=154
	sta wsync		;line=155
	sta wsync		;line=156
x28	lda #$74
	sta wsync		;line=157
	sta hposp1
	DLINEW dli16 1 0 0

dli16
	sta regA
	stx regX
	sty regY

	sta wsync		;line=160
	lda #$01
s8	ldx #$00
x29	ldy #$6E
	sta wsync		;line=161
	sta gtictl
	stx sizep3
	sty hposp3
c46	lda #$FC
	sta colpm3
	DLINEW dli5 1 1 1

dli5
	sta regA
	stx regX
	lda >fnt+$400*$05
	sta wsync		;line=168
	sta chbase
	sta wsync		;line=169
	sta wsync		;line=170
	sta wsync		;line=171
x30	lda #$66
c47	ldx #$FC
	sta wsync		;line=172
	sta hposp2
	stx colpm2
	DLINEW dli17 1 1 0

dli17
	sta regA

	sta wsync		;line=176
	sta wsync		;line=177
	sta wsync		;line=178
	sta wsync		;line=179
	sta wsync		;line=180
	sta wsync		;line=181
	sta wsync		;line=182
x31	lda #$5E
	sta wsync		;line=183
	sta hposp1
	DLINEW dli6 1 0 0

dli6
	sta regA
	lda >fnt+$400*$06
	sta wsync		;line=192
	sta chbase
	DLINEW dli18 1 0 0

dli18
	sta regA
	stx regX
	sty regY

	sta wsync		;line=200
c48	lda #$90
c49	ldx #$0E
c50	ldy #$96
	sta wsync		;line=201
	sta color0
	stx color1
	sty color2
x32	lda #$56
	sta hposp0
c51	lda #$FC
	sta colpm0
c52	lda #$00
	sta wsync		;line=202
	sta color0
	sta wsync		;line=203
	sta wsync		;line=204
c53	lda #$96
c54	ldx #$06
c55	ldy #$0E
	sta wsync		;line=205
	sta color0
	stx color1
	sty color2
c56	lda #$00
c57	ldx #$90
	sta wsync		;line=206
	sta color1
	stx color2
	sta wsync		;line=207
c58	lda #$0E
c59	ldx #$96
	sta wsync		;line=208
	sta color0
	stx color2
c60	lda #$96
c61	ldx #$90
	sta wsync		;line=209
	sta color0
	stx color2
c62	lda #$0E
c63	ldx #$96
	sta wsync		;line=210
	sta color0
	stx color2
c64	lda #$96
c65	ldx #$06
c66	ldy #$0E
	sta wsync		;line=211
	sta color0
	stx color1
	sty color2
c67	lda #$00
c68	ldx #$0E
c69	ldy #$96
	sta wsync		;line=212
	sta color0
	stx color1
	sty color2
c70	lda #$96
c71	ldx #$90
	sta wsync		;line=213
	sta color1
	stx color2
c72	lda #$0E
c73	ldx #$96
	sta wsync		;line=214
	sta color1
	stx color2
c74	lda #$90
	sta wsync		;line=215
	sta color0
	lda >fnt+$400*$00
c75	ldx #$00
c76	ldy #$90
	sta wsync		;line=216
	sta chbase
	stx color0
	sty color1
	lda #$04
	sta gtictl

	lda regA
	ldx regX
	ldy regY
	rti

;---

CHANGES = 1
;---

.proc	NMI

	bit nmist
	bpl VBL

	jmp dli_start
dliv	equ *-2

VBL
	sta regA
	stx regX
	sty regY

	sta nmist		;reset NMI flag

	mwa #ant dlptr		;ANTIC address program

	mva #%00111110 dmactl	;set new screen's width

	inc cloc		;little timer

;--- first line of screen initialization

	lda >fnt+$400*$00
	sta chbase
c0	lda #$0A
	sta colbak
c1	lda #$00
	sta color0
c2	lda #$96
	sta color1
c3	lda #$90
	sta color2
c4	lda #$0E
	sta color3
	lda #$04
	sta gtictl
s0	lda #$00
	sta sizep1
	sta sizem
x0	lda #$C5
	sta hposp1
x1	lda #$CD
	sta hposm1
c5	lda #$7A
	sta colpm1
s1	lda #$03
	sta sizep3
x2	lda #$97
	sta hposp3
x3	lda #$AF
	sta hposm3
c6	lda #$90
	sta colpm3
s2	lda #$00
	sta sizep0
s3	lda #$03
	sta sizep2
x4	lda #$9F
	sta hposp0
x5	lda #$99
	sta hposp2
x6	lda #$B0
	sta hposm0
c7	lda #$F2
	sta colpm0
c8	lda #$00
	sta colpm2
x7	lda #$A8
	sta hposm2

	mwa #dli_start dliv	;set the first address of DLI interrupt

;this area is for yours routines

quit
	lda regA
	ldx regX
	ldy regY
	rti

.endp

;---
	ift CHANGES
	icl 'river8.fad'
	eif

	org $9FFE
	.word main
;---

	opt l-

.MACRO	SPRITES
        .by $00,$00,$00,$00,$00,$00,$00,$00
        .by $00,$00,$00,$00,$00,$00,$00,$00
        .by $00,$00,$00,$00,$00,$00,$00,$00
        .by $00,$00,$00,$00,$00,$00,$00,$00
        .by $00,$00,$00,$00,$00,$00,$08,$08
        .by $00,$00,$80,$C0,$C0,$C0,$00,$00
        .by $00,$00,$C0,$C0,$C0,$C0,$C0,$00
        .by $00,$00,$00,$00,$00,$00,$00,$00
        .by $00,$00,$00,$00,$00,$00,$00,$00
        .by $00,$00,$0C,$0C,$08,$0C,$3E,$3C
        .by $3D,$3D,$3F,$3F,$3F,$3D,$3B,$3B
        .by $33,$37,$33,$37,$37,$3F,$36,$3E
        .by $3E,$34,$38,$30,$30,$20,$00,$00
        .by $00,$00,$00,$00,$00,$00,$00,$00
        .by $00,$00,$00,$00,$00,$00,$00,$00
        .by $00,$00,$00,$00,$00,$00,$00,$00
        .by $00,$00,$00,$00,$00,$00,$00,$00
        .by $00,$00,$00,$00,$00,$00,$00,$0C
        .by $04,$34,$38,$34,$30,$30,$30,$30
        .by $F0,$F0,$F0,$F0,$F0,$F0,$30,$00
        .by $00,$00,$00,$00,$00,$00,$00,$00
        .by $00,$00,$00,$00,$00,$00,$00,$00
        .by $00,$00,$00,$00,$00,$00,$00,$00
        .by $00,$00,$00,$00,$00,$00,$00,$00
        .by $00,$00,$00,$00,$00,$00,$00,$00
        .by $00,$00,$00,$00,$00,$00,$00,$00
        .by $00,$00,$00,$00,$00,$00,$00,$00
        .by $00,$00,$00,$00,$00,$00,$00,$00
        .by $00,$00,$00,$00,$00,$00,$00,$00
        .by $00,$00,$00,$00,$00,$00,$00,$00
        .by $00,$00,$00,$00,$00,$00,$00,$00
        .by $00,$00,$00,$00,$00,$00,$00,$00

	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 01 FF 30 31 73
	.he FF FF FF BF BA B8 B8 A8 08 78 7C 3C 06 3F 03 03
	.he 1F 1F 1F 0F 03 03 2F 1F 0E 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 14 08
	.he 04 26 02 11 28 00 10 20 11 28 3C 6E C2 01 00 00
	.he 00 00 80 80 80 C0 68 00 01 01 03 06 06 04 2E 34
	.he 6E 76 30 7E 1D 0B 04 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 01 01 03 03 07 07 0D 0F 1F 1F 1F 2F 79 78
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00

	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 EA 2A 2A 2E AA 4A 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 30 F0 F0 F0 F8 F8
	.he F8 F8 98 18 18 18 38 38 38 78 78 70 F0 F0 F0 F0
	.he F0 F0 F0 F0 E0 C0 80 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 01 00
	.he 00 00 00 30 02 04 00 40 40 00 00 80 80 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 10 26 7E 7B FE
	.he FC 3E 3F 7F FE 3F 1F 7F 7A FC 7C 7C 78 70 F8 08
	.he 08 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 01 01 01 02 06 06 01 04 0F 0F 16 2F 2F 7F 7F
	.he FF FF FF FF DF FF FF FF DF F7 EF FF FF ED CB C1
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00

	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 FF FF FF FF FF 7F 7F
	.he BF 3C FF FF FF FF FF FF 1F FF FF FF FF 7F 07 7F
	.he 7F 3F 3F 3F 3F 3F 3F 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 6E EF AF 0F
	.he 0F 0F 07 0F 1F 1F 3F 3F 1F 0F 0F 7E 76 3F 3F 7F
	.he 7F BF FF 7F BE 3F 1F 5C 63 62 01 0B 03 00 50 00
	.he 00 C0 20 80 40 80 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 01 01 01 03 01 01 09 1D 1D 33 75 C5
	.he D3 CD A2 A6 00 C1 A0 38 18 46 A7 1E EE ED F7 FF
	.he FD FF FF FE BF FF FF FF F6 FD FF F7 ED FF FE FE
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00

	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 7C 7C 7C 7C 7C FE FE FE
	.he FE FE BF FE FE FE FE FF FF FF FF FF FF FF FF FF
	.he FF FF FF 7F FF FF FF FF FF FF 00 00 00 00 00 00
	.he 00 FF FF FF FF FF FF FF FF 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 FF EE FF EF DF
	.he FD BD FD 3F 7D 7D 78 F8 FA F8 F8 F8 FC FA E3 6B
	.he 6F FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF
	.he FF FF FF FF FF FF FF BF 00 03 07 07 0F 0F 0F 17
	.he 2B 6C 3F 2F EB A7 F7 ED FD 91 58 D0 D0 F0 80 80
	.he 00 00 30 68 50 40 C0 40 00 00 00 A0 A0 60 50 F0
	.he F0 F0 E0 E0 E0 40 80 4C 45 F2 F1 EF F7 EF 7C 58
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
.ENDM

USESPRITES = 1

.MACRO	DLINEW
	mva <:1 NMI.dliv
	ift [>?old_dli]<>[>:1]
	mva >:1 NMI.dliv+1
	eif

	ift :2
	lda regA
	eif

	ift :3
	ldx regX
	eif

	ift :4
	ldy regY
	eif

	rti

	.def ?old_dli = *
.ENDM

